<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Repositories\Eloquent\Admin\CountryRepository;
use App\Http\Repositories\Eloquent\Admin\InfoRepository;
use App\Http\Repositories\Eloquent\Admin\LanguageRepository;
use App\Http\Repositories\Eloquent\Admin\OptionRepository;
use App\Http\Repositories\Eloquent\Admin\RoomTypeRepository;
use App\Http\Repositories\Eloquent\Admin\UserRepository;
use App\Models\User;
use Illuminate\Http\Request;

class HomeController extends Controller
{

    public $user;
    public $userRepository;
    public $infoRepository;
    public $roomTypeRepository;
    public $optionRepository;
    public $countryRepository;
    public $languageRepository;

    public function __construct(
        User $user, UserRepository $userRepository, InfoRepository $infoRepository, RoomTypeRepository $roomTypeRepository,
        OptionRepository $optionRepository, CountryRepository $countryRepository, LanguageRepository $languageRepository,
    )
    {
        $this->user = $user;
        $this->userRepository = $userRepository;
        $this->infoRepository = $infoRepository;
        $this->roomTypeRepository = $roomTypeRepository;
        $this->optionRepository = $optionRepository;
        $this->countryRepository = $countryRepository;
        $this->languageRepository = $languageRepository;
        $this->middleware('auth:api', ['except' => ['test', 'info', 'users', 'options', 'roomTypes', 'countries', 'languages']]);
    }

    public function info()
    {
        $info = $this->infoRepository->getfirst();
        $info->asks = array_values($info->asks ?? []);
        $info->terms = array_values($info->terms ?? []);
        $info->privacy_policies = array_values($info->privacy_policies ?? []);
        return responseJson(200, "success", $info);
    }

    public function test(Request $request)
    {
        return $request->all();
    }

    public function users(Request $request)
    {
        return $this->userRepository->search($request);
    }

    public function options(Request $request)
    {
        return $this->optionRepository->search($request);
    }

    public function roomTypes(Request $request)
    {
        return $this->roomTypeRepository->search($request);
    }

    public function countries(Request $request)
    {
        return $this->countryRepository->search($request);
    }

    public function languages(Request $request)
    {
        return $this->languageRepository->search($request);
    }
}
