<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller
{
    public $contact;

    public function __construct(Contact $contact)
    {
        $this->contact = $contact;
    }

    public function home()
    {
        return view('front/home');
    }

    public function contact(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255',
                'mobile' => 'required|string|max:255',
                'email' => 'required|string|max:255',
                'message' => 'nullable|string|max:1255',
            ]);
            if ($validator->fails()) {
                // return back()->withErrors($validator)->withInput();
                return redirect()->to(url()->previous().'#contact')->withErrors($validator)->withInput();
            }
    
            $this->contact->create([
                'name' => $request->name,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'message' => $request->message,
            ]);
            flash()->success('Success');
            return redirect()->to(url()->previous().'#contact')->withInput();
        } catch (\Exception $ex) {
            flash()->error('There is something wrong , please contact technical support');
            return redirect()->to(url()->previous().'#contact')->withInput();
        }
    }

}
