<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Info;
use App\Models\Point;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use DevxPackage\AbstractRepository;

class WalletRepository extends AbstractRepository
{

    protected $model;
    protected $WalletTransaction;
    protected $info;
    protected $point;

    public function __construct()
    {
        $this->model = new Wallet();
        $this->WalletTransaction = new WalletTransaction();
        $this->info = new Info();
        $this->point = new Point();
    }

    public function crudName(): string
    {
        return 'wallets';
    }

    public function index($request, $offset, $limit)
    {
        return $this->newPagination($request, $offset, $limit);
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function newPagination($request, $offset, $limit)
    {
        // $dd =  $this->model->when($request->filled('user_id') && !is_null($request->user_id), function($q) use($request) {
        return $this->model->when($request->filled('user_id') && !is_null($request->user_id), function($q) use($request) {
            $q->where('typeable_id', $request->user_id)->where('typeable_type', 'App\Models\User');
        })->when($request->filled('group_id') && !is_null($request->group_id), function($q) use($request) {
            $q->where('typeable_id', $request->group_id)->where('typeable_type', 'App\Models\ChatGroup');
        })->with($this->model->model_relations())->withCount($this->model->model_relations_counts())
        ->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
        dd($dd);
    }

    public function create()
    {
        return view('admin.wallets.create');
    }

    public function edit($id)
    {
        $wallet = $this->findOne($id);
        return view('admin.wallets.update', compact('wallet'));
    }

    public function archivesPage($offset, $limit)
    {
        $wallets = $this->archives($offset, $limit);
        return view('admin.wallets.archives', compact('wallets'));
    }

    public function confirm_withdraw($id)
    {
        $transaction = $this->WalletTransaction->where('id', $id)->first();
        $transaction->update([
            'status' => 1,
            'confirm_withdraw_by' => auth()->guard('admin')->user()->id,
        ]);
        $this->updateBalance($transaction->wallet_id);
        return $transaction;
    }

    public function updateBalance($wallet_id)
    {
        $wallet = $this->model->with(['deposit_transactions', 'withdraw_transactions'])->where('id', $wallet_id)->first();
        $deposit_transactions_amount = array_sum(array_column($wallet->deposit_transactions->toArray(), 'amount')) ?? 0;
        $withdraw_transactions_amount = array_sum(array_column($wallet->withdraw_transactions->toArray(), 'amount')) ?? 0;
        $wallet->update(['balance' => $deposit_transactions_amount - $withdraw_transactions_amount]);
    }    

    public function calcPoints($transaction)
    {
        $infoData = $this->info->first();
        
        $earned = 0;
        $pointsPerUnit = (int) ($infoData->points ?? 0);
        $amountForPoints = (float) ($infoData->amount_for_points ?? 0);
        if ($amountForPoints > 0 && $pointsPerUnit > 0) {
            $multiplier = (int) floor((float) $transaction->amount / $amountForPoints);
            $earned = $multiplier * $pointsPerUnit;
        }

        $point = $this->point->create([
            'user_id' => $transaction->user_id,
            'amount' => $transaction->amount,
            'points' => $earned,
            'status' => 1,
            'transaction_id' => $transaction->id,
        ]);
        return $point;
    }    

}