<?php

namespace App\Http\Requests\Admin\InfoRequests;

use Illuminate\Foundation\Http\FormRequest;

class InfoUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            'mobile' => 'required|string',
            'email' => 'required|string',
            'desc' => 'required|string',
            'message' => 'required|string',
            'vision' => 'required|string',
            'points' => 'required|integer',
            'amount_for_points' => 'required|integer',

            'asks' => 'nullable|array',
            'asks.*.head' => 'required|string',
            'asks.*.body' => 'required|string',
            
            'privacy_policies' => 'nullable|array',
            'privacy_policies.*.head' => 'required|string',
            'privacy_policies.*.body' => 'required|string',
            
            'terms' => 'nullable|array',
            'terms.*.head' => 'required|string',
            'terms.*.body' => 'required|string',
        ];
    }
}
