<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CafeOrder extends Model
{
    protected $table = 'cafe_orders';
	protected $fillable = [
		'status',
		'cafe_id',
		'added_by',
		'day',
		'cost',
		'table_time',
		'provider_id',
		'chat_group_id',
		'trip_id',
		'persons_count',
		'deleted_at',
		'canceled_by',
	];
    public $timestamps = true;

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'status' => '',
			'cafe_id' => '',
			'added_by' => '',
			'day' => '',
			'table_time' => '',
			'persons_count' => '',
			'deleted_at' => '',
			'provider_id' => '',
			'cost' => '',
			'chat_group_id' => '',
			'trip_id' => '',
			'canceled_by' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['cafe', 'user'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function cafe()
	{
		return $this->belongsTo(Cafe::class, 'cafe_id');	
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'added_by');	
	}

	public function provider()
	{
		return $this->belongsTo(User::class, 'provider_id');	
	}

	public function chat_group()
	{
		return $this->belongsTo(ChatGroup::class, 'chat_group_id');	
	}

	public function orderable()
    {
        return $this->morphMany(WalletTransaction::class, 'orderable');
    }
}