<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;
use Astrotomic\Translatable\Translatable;

class Car extends Model implements TranslatableContract
{
    use Translatable;
    protected $table = 'cars';
	protected $fillable = [
		'owner',
		'persons_count',
		'price',
		'offer',
		'mobile',
		'img',
		'attributes',
		'country_id',
		'owner_id',
	];
    public $timestamps = true;
	public $useTranslationFallback = true;
	public $translatedAttributes = ['name'];
    public $translationForeignKey = 'car_id';
	protected $hidden = ['offer', 'mobile'];
	
    public function getAttributesAttribute($value)
    {
        return explode(',', $value);
    }

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'owner' => '',
			'persons_count' => '',
			'price' => '',
			'offer' => '',
			// 'mobile' => '',
			'img' => '',
			'country_id' => '',
			'owner_id' => '',
			'attributes' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['country', 'captain', 'owner'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function country()
	{
		return $this->belongsTo(Country::class, 'country_id');	
	}

	public function owner()
	{
		return $this->belongsTo(User::class, 'owner_id');	
	}

	public function captain()
	{
		return $this->belongsTo(Captain::class, 'captain_id');
	}
    
	public function favorate_services()
    {
        return $this->morphMany(FavorateService::class, 'serviceable');
    }

	public function ratings()
    {
        return $this->morphMany(Rating::class, 'serviceable')->where('is_activate', 1);
    }

	public function orders()
    {
        return $this->hasMany(CarOrder::class, 'car_id');
    }
}