<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Rating extends Model
{
    protected $table = 'ratings';
	protected $fillable = ['comment', 'rating', 'user_id', 'serviceable_id', 'serviceable_type', 'is_activate'];
    public $timestamps = true;

	public function getForAttribute()
	{
		if ($this->serviceable_type == 'App\Models\User')
			return "Guide";
		elseif ($this->serviceable_type == 'App\Models\Car')
			return "Car";
		elseif ($this->serviceable_type == 'App\Models\Hotel')
			return "Hotel";
		elseif ($this->serviceable_type == 'App\Models\Cafe')
			return "Cafe";
		elseif ($this->serviceable_type == 'App\Models\Restaurant')
			return "Restaurant";
		elseif ($this->serviceable_type == 'App\Models\Destination')
			return "Destination";

		return '';
	}

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return ['comment' => '', 'rating' => '', 'user_id' => ''];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['user', 'serviceable'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function serviceable()
    {
        return $this->morphTo();
    }

	public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}