<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Trip extends Model
{
    protected $table = 'trips';
	protected $fillable = [
		'name',
		'img',
		'duration',
		'from',
		'to',
		'chat_group_id',
		'added_by',
	];
    public $timestamps = true;

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'name' => '',
			'img' => '',
			'duration' => '',
			'from' => '',
			'to' => '',
			'chat_group_id' => '',
			'added_by' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function chat_group()
	{
		return $this->belongsTo(ChatGroup::class, 'chat_group_id');
	}

	public function car_orders()
	{
		return $this->hasMany(CarOrder::class, 'trip_id');
	}

	public function cafe_orders()
	{
		return $this->hasMany(CafeOrder::class, 'trip_id');
	}

	public function hotel_orders()
	{
		return $this->hasMany(HotelOrder::class, 'trip_id');
	}

	public function restaurant_orders()
	{
		return $this->hasMany(RestaurantOrder::class, 'trip_id');
	}
}