<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',

        'mobile', 
        'img', 
        'code', 
        'user_type', 
        'deleted_at', 
        'is_activate', 
        'day_price', 
        'hour_price', 
        'info', 
        'experience', 
        'interests', 
        'tours_type', 
        'country_id', 
        'mobile_verified_at',
        'fcm_token',
        'iban',
        'logo',
        'documented_files',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'code',
        'remember_token',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }


    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getDocumentedFilesAttribute($value)
    {
        return explode(',', $value);
    }

    public function getInterestsAttribute($value)
    {
        return explode(',', $value);
    }

    public function getToursTypeAttribute($value)
    {
        return explode(',', $value);
    }

    public function scopeGuides($query){
		return $query->where('user_type', 2);
	}

    public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}
	
	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}

	public function fildes(){
		return [
            'name' => '',
            'email' => '',
            'password' => '',
    
            'mobile' => '', 
            'img' => '', 
            'code' => '', 
            'user_type' => '', 
            'day_price' => '', 
            'hour_price' => '', 
            'info' => '', 
            'experience' => '', 
            'interests' => '', 
            'tours_type' => '', 
            'country_id' => '', 

            'languages' => '',
            'days' => '',
            'fcm_token' => '',
            'iban' => '',
            'logo' => '',
            'documented_files' => '',
        ];
	}

	public function updateFildes(){
		return [
            'name' => '',
            'email' => '',
     
            'img' => '',  
            'day_price' => '', 
            'hour_price' => '', 
            'info' => '', 
            'experience' => '', 
            'interests' => '', 
            'tours_type' => '', 

            'languages' => '',
            'days' => '',
            'iban' => '',
            'logo' => '',
            'documented_files' => '',
            'album' => '',
        ];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('email', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->orWhere('mobile', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('email', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->orWhere('mobile', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['country'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'user_id');
	}

	public function personal_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'user_id')->whereNull('chat_group_id');
	}

	public function group_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'user_id')->whereNotNull('chat_group_id');
	}

	public function languages()
	{
		return $this->belongsToMany(Language::class, 'user_languages');
	}

	public function country()
	{
		return $this->belongsTo(Country::class, 'country_id');	
	}

	public function points()
	{
		return $this->hasMany(Point::class, 'user_id');
	}

	public function unused_points()
	{
		return $this->hasMany(Point::class, 'user_id')->where('status', 1);
	}

	public function days()
	{
		return $this->hasMany(GuideDaysWork::class, 'guide_id');
	}

    public function favorate_guides()
    {
        return $this->belongsToMany(User::class, 'favorate_guides', 'user_id');
    }
    
	public function favorate_services()
    {
        return $this->hasMany(FavorateService::class);
        // return $this->morphMany(FavorateService::class, 'serviceable');
    }
    
	public function groups()
    {
        return $this->hasMany(ChatGroup::class, 'added_by_id');
    }

	public function wallet()
    {
        return $this->morphOne(Wallet::class, 'typeable');
    }

	public function ratings()
    {
        return $this->morphMany(Rating::class, 'serviceable')->where('is_activate', 1);
    }

	public function client_notifications()
    {
        return $this->hasMany(Notification::class, 'user_id');
    }

	public function provider_notifications()
    {
        return $this->hasMany(Notification::class, 'provider_id');
    }

	public function album()
    {
        return $this->hasMany(GuideAlbum::class, 'guide_id');
    }
 
    /////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function car_orders()
    {
        return $this->hasMany(CarOrder::class, 'provider_id');
    }

	public function hotel_orders()
    {
        return $this->hasMany(HotelOrder::class, 'provider_id');
    }

	public function restaurant_orders()
    {
        return $this->hasMany(RestaurantOrder::class, 'provider_id');
    }

	public function cafe_orders()
    {
        return $this->hasMany(CafeOrder::class, 'provider_id');
    }

	public function guide_orders()
    {
        return $this->hasMany(GuideOrder::class, 'guide_id');
    }
}
