<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chat_group_messages', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->test('message')->nullable();
            $table->string('file', 255)->nullable();
            $table->string('message_type', 255)->nullable()->comment('1 => message , 2 => img , 3 => video , 4 => voice');
            $table->integer('added_by_id')->nullable();
            $table->integer('group_id')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
            $table->tinyInteger('is_multiple')->default(0)->comment('0 => single , 1 => multiple');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chat_group_messages');
    }
};
