<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('interactions', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->nullableMorphs('commentable');
            $table->integer('user_id')->nullable();
            $table->integer('react')->nullable()->comment('1 => heart, 2 => clap, 3 => thumbs_up, 4 => tears_of_joy, 5 => wow, 6 => cry, 7 => heart_eyes, 8 => fire');
            $table->string('comment', 1255)->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('interactions');
    }
};
