<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->integer('hotel_id')->nullable();
            $table->integer('owner_id')->nullable();
            $table->integer('room_type_id')->nullable();
            // $table->string('info', 1255)->nullable();
            $table->integer('room_count')->nullable();
            $table->integer('person_count')->nullable();
            $table->decimal('price')->nullable();
            $table->string('img', 255)->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rooms');
    }
};
