<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallet_transactions', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->integer('wallet_id')->nullable();
            $table->integer('chat_group_id')->nullable();
            $table->decimal('amount', 12, 2)->nullable();
            $table->string('description', 255)->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('transfer_from_id')->nullable();
            $table->tinyInteger('type')->comment('1 => deposit , 2 => withdraw , 3 => transfer')->default(0);
            $table->integer('confirm_withdraw_by')->nullable();
            $table->tinyInteger('status')->comment('0 => not compeleted , 1 => compeleted')->default(0);
            $table->string('getway_transaction_id')->nullable();
            $table->string('payment_method_types')->nullable();
            $table->integer('provider_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_transactions');
    }
};
