@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Restaurants</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/restaurants/index')}}/0/{{PAGINATION_COUNT}}">Restaurants</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Create</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Restaurant Form</h4>
                        </div>
                        <div class="card-body">
                            <form role="form" action="{{url(route('admin/restaurants/create'))}}" method="post" enctype="multipart/form-data">
                                <div class="live-preview">
                                    @csrf
                                    <div class="row gy-4">

                                        <div class="card mt-xxl-n5">
                                            <div class="card-header">
                                                <ul class="nav nav-tabs card-header-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active fw-bold" data-bs-toggle="tab" href="#enLang" role="tab" style="border-width: 4px;">
                                                            <span class="text-danger">*</span> البيانات الاساسيه (EN)
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#arLang" role="tab" style="border-width: 4px;">
                                                            AR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#frLang" role="tab" style="border-width: 4px;">
                                                            FR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#trLang" role="tab" style="border-width: 4px;">
                                                            TR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#hiLang" role="tab" style="border-width: 4px;">
                                                            HI
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#days_tab" role="tab" style="border-width: 4px;">
                                                            ايام العمل
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#meal_times" role="tab" style="border-width: 4px;">
                                                            مواعيد الطعام
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        

                                            <div class="card-body p-4">
                                                <div class="tab-content">
                                                    
                                                    <div class="tab-pane active" id="enLang" role="tabpanel">
                                                        <div class="row">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name en <span class="text-danger">*</span></label>
                                                                    <input name="name[en]" type="text" class="form-control" id="namefloatingInput" placeholder="name en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info en <span class="text-danger">*</span></label>
                                                                    <input name="info[en]" type="text" class="form-control" id="infofloatingInput" placeholder="info en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location en <span class="text-danger">*</span></label>
                                                                    <input name="location[en]" type="text" class="form-control" id="locationfloatingInput" placeholder="location en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3"></div>
                                                            
                                                            <div class="col-xxl-6 col-md-6">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 7px;" for="">المالك <span class="text-danger">*</span></label><br/>
                                                                    <select name="owner_id" id="users" class="form-control">
                                                                        <option value="">---</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="map_locationfloatingInput">map location <span class="text-danger">*</span></label>
                                                                    <input name="map_location" type="text" class="form-control" id="map_locationfloatingInput" placeholder="map location">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="filefloatingInput">img <span class="text-danger">*</span></label>
                                                                    <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                                                </div>
                                                            </div> 
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="avg_pricesfloatingInput">Avg prices <span class="text-danger">*</span></label>
                                                                    <input name="avg_prices" type="number" class="form-control" id="avg_pricesfloatingInput" placeholder="day price">
                                                                </div>
                                                            </div>
                                                            {{-- <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="offerfloatingInput">offer <span class="text-danger"></span></label>
                                                                    <input name="offer" type="number" class="form-control" id="offerfloatingInput" placeholder="offer">
                                                                </div>
                                                            </div> --}}
                                                            <div class="col-xxl-6 col-md-6">
                                                                <div class="form-group">
                                                                    <label style="margin-bottom: 7px;" for="">الدوله <span class="text-danger">*</span></label><br/>
                                                                    <select name="country_id" id="countries" class="form-control">
                                                                        <option value="">---</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="arLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name ar <span class="text-danger"></span></label>
                                                                    <input name="name[ar]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info ar <span class="text-danger"></span></label>
                                                                    <input name="info[ar]" type="text" class="form-control" id="infofloatingInput" placeholder="info ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location ar <span class="text-danger"></span></label>
                                                                    <input name="location[ar]" type="text" class="form-control" id="locationfloatingInput" placeholder="location ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="frLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name fr <span class="text-danger"></span></label>
                                                                    <input name="name[fr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info fr <span class="text-danger"></span></label>
                                                                    <input name="info[fr]" type="text" class="form-control" id="infofloatingInput" placeholder="info fr">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location fr <span class="text-danger"></span></label>
                                                                    <input name="location[fr]" type="text" class="form-control" id="locationfloatingInput" placeholder="location fr">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="trLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name tr <span class="text-danger"></span></label>
                                                                    <input name="name[tr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info tr <span class="text-danger"></span></label>
                                                                    <input name="info[tr]" type="text" class="form-control" id="infofloatingInput" placeholder="info tr">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location tr <span class="text-danger"></span></label>
                                                                    <input name="location[tr]" type="text" class="form-control" id="locationfloatingInput" placeholder="location tr">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="hiLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name hi <span class="text-danger"></span></label>
                                                                    <input name="name[hi]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="infofloatingInput">info hi <span class="text-danger"></span></label>
                                                                    <input name="info[hi]" type="text" class="form-control" id="infofloatingInput" placeholder="info hi">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="locationfloatingInput">location hi <span class="text-danger"></span></label>
                                                                    <input name="location[hi]" type="text" class="form-control" id="locationfloatingInput" placeholder="location hi">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="days_tab" role="tabpanel">
                                                        
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-2 col-md-2 mb-3 mt-5">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput200" style="font-size: 20px;">open all time <span class="text-danger"></span></label>
                                                                        <input name="open_all_time" type="checkbox" class="m-1" id="namefloatingInput200" value="1">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput10">السبت <span class="text-danger"></span></label>
                                                                        <input name="days[0][day]" type="text" class="form-control" id="namefloatingInput10" value="السبت" placeholder="السبت" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput20">start <span class="text-danger"></span></label>
                                                                        <input name="days[0][start]" type="time" class="form-control" id="namefloatingInput20" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput30">end <span class="text-danger"></span></label>
                                                                        <input name="days[0][end]" type="time" class="form-control" id="namefloatingInput30" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput40">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[0][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput11">الاحد <span class="text-danger"></span></label>
                                                                        <input name="days[1][day]" type="text" class="form-control" id="namefloatingInput11" value="الاحد" placeholder="الاحد" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput21">start <span class="text-danger"></span></label>
                                                                        <input name="days[1][start]" type="time" class="form-control" id="namefloatingInput21" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput31">end <span class="text-danger"></span></label>
                                                                        <input name="days[1][end]" type="time" class="form-control" id="namefloatingInput31" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput41">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[1][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput12">الاثنين <span class="text-danger"></span></label>
                                                                        <input name="days[2][day]" type="text" class="form-control" id="namefloatingInput12" value="الاثنين" placeholder="الاثنين" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput22">start <span class="text-danger"></span></label>
                                                                        <input name="days[2][start]" type="time" class="form-control" id="namefloatingInput22" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput32">end <span class="text-danger"></span></label>
                                                                        <input name="days[2][end]" type="time" class="form-control" id="namefloatingInput32" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput43">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[2][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput13">الثلاثاء <span class="text-danger"></span></label>
                                                                        <input name="days[3][day]" type="text" class="form-control" id="namefloatingInput13" value="الثلاثاء" placeholder="الثلاثاء" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput23">start <span class="text-danger"></span></label>
                                                                        <input name="days[3][start]" type="time" class="form-control" id="namefloatingInput23" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput33">end <span class="text-danger"></span></label>
                                                                        <input name="days[3][end]" type="time" class="form-control" id="namefloatingInput33" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput43">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[3][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput14">الاربعاء <span class="text-danger"></span></label>
                                                                        <input name="days[4][day]" type="text" class="form-control" id="namefloatingInput14" value="الاربعاء" placeholder="الاربعاء" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput24">start <span class="text-danger"></span></label>
                                                                        <input name="days[4][start]" type="time" class="form-control" id="namefloatingInput24" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput34">end <span class="text-danger"></span></label>
                                                                        <input name="days[4][end]" type="time" class="form-control" id="namefloatingInput34" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput44">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[4][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput15">الخميس <span class="text-danger"></span></label>
                                                                        <input name="days[5][day]" type="text" class="form-control" id="namefloatingInput15" value="الخميس" placeholder="الخميس" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput25">start <span class="text-danger"></span></label>
                                                                        <input name="days[5][start]" type="time" class="form-control" id="namefloatingInput25" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput35">end <span class="text-danger"></span></label>
                                                                        <input name="days[5][end]" type="time" class="form-control" id="namefloatingInput35" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput45">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[5][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-3 col-md-3 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput16">الجمعه <span class="text-danger"></span></label>
                                                                        <input name="days[6][day]" type="text" class="form-control" id="namefloatingInput16" value="الجمعه" placeholder="الجمعه" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput26">start <span class="text-danger"></span></label>
                                                                        <input name="days[6][start]" type="time" class="form-control" id="namefloatingInput26" placeholder="start">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput36">end <span class="text-danger"></span></label>
                                                                        <input name="days[6][end]" type="time" class="form-control" id="namefloatingInput36" placeholder="end">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput46">day status <span class="text-danger"></span></label><br>
                                                                        <select class="form-control" name="days[6][day_status]">
                                                                            <option value="">اختر</option>
                                                                            <option value="1">طول اليوم</option>
                                                                            <option value="2">اجازه</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="meal_times" role="tabpanel">
                                                        <div class="col-xxl-6 col-md-6">
                                                            <button class="btn btn-primary mb-3" id="add-input-time" type="button" style="background: #84BD5E;">
                                                                <i class="bx bx-plus"></i> add time
                                                            </button>
                                                        </div>
                                                        <div class="input-container input-container-0 mb-3">
                                                            <div class="row">
                                                                <div class="col-xxl-5 col-md-5 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="namefloatingInput">time <span class="text-danger"></span></label>
                                                                        <input name="times[0][time]" type="time" class="form-control" id="namefloatingInput" placeholder="time">
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-5 col-md-5 mb-3">
                                                                    <div class="group-form">
                                                                        <label for="infofloatingInput">time type <span class="text-danger"></span></label>
                                                                        {{-- <input name="times[0][type]" type="text" class="form-control" id="infofloatingInput" placeholder="time type"> --}}
                                                                        <select class="form-control" name="times[0][type]">
                                                                            <option value="">اختر</option>
                                                                            <option value="الفطار">الفطار</option>
                                                                            <option value="الغداء">الغداء</option>
                                                                            <option value="العشاء">العشاء</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xxl-2 col-md-2">
                                                                    <label for="" class="mb-2"></label>
                                                                    <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-0"><i class="bx bx-trash"></i></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="times-area"></div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button class="btn btn-primary" type="submit">Submit form</button>
                                            <button class="btn btn-success" type="reset">Reset Button</button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebarrestaurants').addClass('active');
        var target = $('.sidebarrestaurants').attr('href');
        $(target).addClass('show');
    })();
    $('#countries').select2({
        ajax: {
            url: "{{ route('get/countries') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });
    $('#users').select2({
        ajax: {
            url: "{{ route('get/users') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });

    let inputCount = 10;
    $('#add-input-time').click(function () {

        inputCount++;
        $('#times-area').append(`
            <div class="input-container input-container-${inputCount} mb-3">
                <div class="row">
                    <div class="col-xxl-5 col-md-5 mb-3">
                        <div class="group-form">
                            <label for="namefloatingInput">time <span class="text-danger"></span></label>
                            <input name="times[${inputCount}][time]" type="time" class="form-control" id="namefloatingInput" placeholder="time">
                        </div>
                    </div>
                    <div class="col-xxl-5 col-md-5 mb-3">
                        <div class="group-form">
                            <label for="infofloatingInput">time type <span class="text-danger"></span></label>
                            <select class="form-control" name="times[${inputCount}][type]">
                                <option value="">اختر</option>
                                <option value="الفطار">الفطار</option>
                                <option value="الغداء">الغداء</option>
                                <option value="العشاء">العشاء</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-md-2">
                        <label for="" class="mb-2"></label>
                        <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-${inputCount}"><i class="bx bx-trash"></i></span>
                    </div>
                </div>
            </div>
        `);
    });
    $(document).on('click', '.remove-btn', function () {
        var parentClass = $(this).attr('parent-class');
        $('.'+parentClass).remove();
    });
</script>
@endsection
