<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group([ 'namespace' => 'App\Http\Controllers\Admin', 'prefix' => 'admin-panel' ], function(){
        
    // login routes
    Route::get('/', 'AuthController@login');
    Route::get('login', 'AuthController@login')->name('admin/login');
    Route::post('login', 'AuthController@check_login')->name('admin/check-login');
    
    Route::group(['middleware' => ['adminLogin', 'limitReq']], function(){
      
        Route::get('get/languages', 'HomeController@languages')->name('get/languages');
        Route::get('get/countries', 'HomeController@countries')->name('get/countries');
        Route::get('get/captains', 'HomeController@captains')->name('get/captains');
        Route::get('get/users', 'HomeController@users')->name('get/users');
        Route::get('get/groups', 'HomeController@groups')->name('get/groups');
        Route::get('get/hotels', 'HomeController@hotels')->name('get/hotels');
        Route::get('get/roomtypes', 'HomeController@room_types')->name('get/roomtypes');
        Route::get('get/options', 'HomeController@options')->name('get/options');
        
        Route::get('/home', 'HomeController@home')->name('admin/index');
        Route::get('logout', 'AuthController@logout')->name('admin/logout');

        // admin routes
        Route::get('admins/info', 'AdminController@info')->name('admin/admins/info');
        Route::post('admins/info-update', 'AdminController@info_update')->name('admin/admins/info-update');
        Route::post('admins/change-password', 'AdminController@change_password')->name('admin/admins/change-password');
        
        Route::get('admins/index/{offset?}/{limit?}', 'AdminController@index')->name('admin/admins/index');
        Route::get('admins/create', 'AdminController@create')->name('admin/admins/create');
        Route::post('admins/create', 'AdminController@store')->name('admin/admins/store');
        Route::get('admins/activate', 'AdminController@activate')->name('admin/admins/activate');
        Route::get('admins/delete', 'AdminController@delete')->name('admin/admins/delete');
        Route::post('admins/pagination/{offset?}/{limit?}', 'AdminController@pagination')->name('admin/admins/pagination');
        Route::post('admins/search', 'AdminController@search')->name('admin/admins/search');
        Route::post('admins/search/byColumn', 'AdminController@searchByColumn')->name('admin/admins/search/byColumn'); 
        Route::get('admins/archives/{offset?}/{limit?}', 'AdminController@archives')->name('admin/admins/archives');
        Route::get('admins/back', 'AdminController@back')->name('admin/admins/back');
        Route::post('admins/pagination/archives/{offset?}/{limit?}', 'AdminController@archivesPagination')->name('admin/admins/pagination/archives');
        Route::post('admins/search/archives', 'AdminController@archivesSearch')->name('admin/admins/search/archives');
        Route::post('admins/search/byColumn/archives', 'AdminController@archivesSearchByColumn')->name('admin/admins/search/byColumn/archives');

        
      	    
        // user routes
        Route::get('users/index/{offset?}/{limit?}', 'UserController@index')->name('admin/users/index');
        Route::get('users/create', 'UserController@create')->name('admin/users/create');
        Route::post('users/create', 'UserController@store')->name('admin/users/store');
        Route::get('users/edit/{id?}', 'UserController@edit')->name('admin/users/edit');
        Route::post('users/edit/{id}', 'UserController@update')->name('admin/users/update');
        Route::get('users/activate', 'UserController@activate')->name('admin/users/activate');
        Route::get('users/delete', 'UserController@delete')->name('admin/users/delete');
        Route::post('users/pagination/{offset?}/{limit?}', 'UserController@pagination')->name('admin/users/pagination');
        Route::post('users/search', 'UserController@search')->name('admin/users/search');
        Route::post('users/search/byColumn', 'UserController@searchByColumn')->name('admin/users/search/byColumn');
        Route::get('users/archives/{offset?}/{limit?}', 'UserController@archives')->name('admin/users/archives');
        Route::get('users/back', 'UserController@back')->name('admin/users/back');
        Route::post('users/pagination/archives/{offset?}/{limit?}', 'UserController@archivesPagination')->name('admin/users/pagination/archives');
        Route::post('users/search/archives', 'UserController@archivesSearch')->name('admin/users/search/archives');
        Route::post('users/search/byColumn/archives', 'UserController@archivesSearchByColumn')->name('admin/users/search/byColumn/archives');
        Route::get('users/orders/{offset?}/{limit?}', 'UserController@orders')->name('admin/users/orders');

        
          
        // language routes
        Route::get('languages/index/{offset?}/{limit?}', 'LanguageController@index')->name('admin/languages/index');
        Route::get('languages/create', 'LanguageController@create')->name('admin/languages/create');
        Route::post('languages/create', 'LanguageController@store')->name('admin/languages/store');
        Route::get('languages/edit/{id?}', 'LanguageController@edit')->name('admin/languages/edit');
        Route::post('languages/edit/{id}', 'LanguageController@update')->name('admin/languages/update');
        Route::get('languages/activate', 'LanguageController@activate')->name('admin/languages/activate');
        Route::get('languages/delete', 'LanguageController@delete')->name('admin/languages/delete');
        Route::post('languages/pagination/{offset?}/{limit?}', 'LanguageController@pagination')->name('admin/languages/pagination');
        Route::post('languages/search', 'LanguageController@search')->name('admin/languages/search');
        Route::post('languages/search/byColumn', 'LanguageController@searchByColumn')->name('admin/languages/search/byColumn');
        Route::get('languages/archives/{offset?}/{limit?}', 'LanguageController@archives')->name('admin/languages/archives');
        Route::get('languages/back', 'LanguageController@back')->name('admin/languages/back');
        Route::post('languages/pagination/archives/{offset?}/{limit?}', 'LanguageController@archivesPagination')->name('admin/languages/pagination/archives');
        Route::post('languages/search/archives', 'LanguageController@archivesSearch')->name('admin/languages/search/archives');
        Route::post('languages/search/byColumn/archives', 'LanguageController@archivesSearchByColumn')->name('admin/languages/search/byColumn/archives');

        
          
        // hotel routes
        Route::get('hotels/index/{offset?}/{limit?}', 'HotelController@index')->name('admin/hotels/index');
        Route::get('hotels/create', 'HotelController@create')->name('admin/hotels/create');
        Route::post('hotels/create', 'HotelController@store')->name('admin/hotels/store');
        Route::get('hotels/edit/{id?}', 'HotelController@edit')->name('admin/hotels/edit');
        Route::post('hotels/edit/{id}', 'HotelController@update')->name('admin/hotels/update');
        Route::get('hotels/activate', 'HotelController@activate')->name('admin/hotels/activate');
        Route::get('hotels/delete', 'HotelController@delete')->name('admin/hotels/delete');
        Route::post('hotels/pagination/{offset?}/{limit?}', 'HotelController@pagination')->name('admin/hotels/pagination');
        Route::post('hotels/search', 'HotelController@search')->name('admin/hotels/search');
        Route::post('hotels/search/byColumn', 'HotelController@searchByColumn')->name('admin/hotels/search/byColumn');
        Route::get('hotels/archives/{offset?}/{limit?}', 'HotelController@archives')->name('admin/hotels/archives');
        Route::get('hotels/back', 'HotelController@back')->name('admin/hotels/back');
        Route::post('hotels/pagination/archives/{offset?}/{limit?}', 'HotelController@archivesPagination')->name('admin/hotels/pagination/archives');
        Route::post('hotels/search/archives', 'HotelController@archivesSearch')->name('admin/hotels/search/archives');
        Route::post('hotels/search/byColumn/archives', 'HotelController@archivesSearchByColumn')->name('admin/hotels/search/byColumn/archives');
        Route::post('hotels/upload/albums/{id?}', 'HotelController@uploadAlbums')->name('admin/hotels/upload/albums');
        Route::post('hotels/delete/img/{id?}', 'HotelController@deleteImg')->name('admin/hotels/delete/img');
        Route::get('hotels/orders/{offset?}/{limit?}', 'HotelController@orders')->name('admin/hotels/orders');
        
          
        // cafe routes
        Route::get('cafes/index/{offset?}/{limit?}', 'CafeController@index')->name('admin/cafes/index');
        Route::get('cafes/create', 'CafeController@create')->name('admin/cafes/create');
        Route::post('cafes/create', 'CafeController@store')->name('admin/cafes/store');
        Route::get('cafes/edit/{id?}', 'CafeController@edit')->name('admin/cafes/edit');
        Route::post('cafes/edit/{id}', 'CafeController@update')->name('admin/cafes/update');
        Route::get('cafes/activate', 'CafeController@activate')->name('admin/cafes/activate');
        Route::get('cafes/delete', 'CafeController@delete')->name('admin/cafes/delete');
        Route::post('cafes/pagination/{offset?}/{limit?}', 'CafeController@pagination')->name('admin/cafes/pagination');
        Route::post('cafes/search', 'CafeController@search')->name('admin/cafes/search');
        Route::post('cafes/search/byColumn', 'CafeController@searchByColumn')->name('admin/cafes/search/byColumn');
        Route::get('cafes/archives/{offset?}/{limit?}', 'CafeController@archives')->name('admin/cafes/archives');
        Route::get('cafes/back', 'CafeController@back')->name('admin/cafes/back');
        Route::post('cafes/pagination/archives/{offset?}/{limit?}', 'CafeController@archivesPagination')->name('admin/cafes/pagination/archives');
        Route::post('cafes/search/archives', 'CafeController@archivesSearch')->name('admin/cafes/search/archives');
        Route::post('cafes/search/byColumn/archives', 'CafeController@archivesSearchByColumn')->name('admin/cafes/search/byColumn/archives');
        Route::post('cafes/upload/albums/{id?}', 'CafeController@uploadAlbums')->name('admin/cafes/upload/albums');
        Route::post('cafes/delete/img/{id?}', 'CafeController@deleteImg')->name('admin/cafes/delete/img');
        Route::get('cafes/orders/{offset?}/{limit?}', 'CafeController@orders')->name('admin/cafes/orders');
        
        // restaurant routes
        Route::get('restaurants/index/{offset?}/{limit?}', 'RestaurantController@index')->name('admin/restaurants/index');
        Route::get('restaurants/create', 'RestaurantController@create')->name('admin/restaurants/create');
        Route::post('restaurants/create', 'RestaurantController@store')->name('admin/restaurants/store');
        Route::get('restaurants/edit/{id?}', 'RestaurantController@edit')->name('admin/restaurants/edit');
        Route::post('restaurants/edit/{id}', 'RestaurantController@update')->name('admin/restaurants/update');
        Route::get('restaurants/activate', 'RestaurantController@activate')->name('admin/restaurants/activate');
        Route::get('restaurants/delete', 'RestaurantController@delete')->name('admin/restaurants/delete');
        Route::post('restaurants/pagination/{offset?}/{limit?}', 'RestaurantController@pagination')->name('admin/restaurants/pagination');
        Route::post('restaurants/search', 'RestaurantController@search')->name('admin/restaurants/search');
        Route::post('restaurants/search/byColumn', 'RestaurantController@searchByColumn')->name('admin/restaurants/search/byColumn');
        Route::get('restaurants/archives/{offset?}/{limit?}', 'RestaurantController@archives')->name('admin/restaurants/archives');
        Route::get('restaurants/back', 'RestaurantController@back')->name('admin/restaurants/back');
        Route::post('restaurants/pagination/archives/{offset?}/{limit?}', 'RestaurantController@archivesPagination')->name('admin/restaurants/pagination/archives');
        Route::post('restaurants/search/archives', 'RestaurantController@archivesSearch')->name('admin/restaurants/search/archives');
        Route::post('restaurants/search/byColumn/archives', 'RestaurantController@archivesSearchByColumn')->name('admin/restaurants/search/byColumn/archives');
        Route::post('restaurants/upload/albums/{id?}', 'RestaurantController@uploadAlbums')->name('admin/restaurants/upload/albums');
        Route::post('restaurants/delete/img/{id?}', 'RestaurantController@deleteImg')->name('admin/restaurants/delete/img');
        Route::get('restaurants/orders/{offset?}/{limit?}', 'RestaurantController@orders')->name('admin/restaurants/orders');


        // car routes
        Route::get('cars/index/{offset?}/{limit?}', 'CarController@index')->name('admin/cars/index');
        Route::get('cars/create', 'CarController@create')->name('admin/cars/create');
        Route::post('cars/create', 'CarController@store')->name('admin/cars/store');
        Route::get('cars/edit/{id?}', 'CarController@edit')->name('admin/cars/edit');
        Route::post('cars/edit/{id}', 'CarController@update')->name('admin/cars/update');
        Route::get('cars/activate', 'CarController@activate')->name('admin/cars/activate');
        Route::get('cars/delete', 'CarController@delete')->name('admin/cars/delete');
        Route::post('cars/pagination/{offset?}/{limit?}', 'CarController@pagination')->name('admin/cars/pagination');
        Route::post('cars/search', 'CarController@search')->name('admin/cars/search');
        Route::post('cars/search/byColumn', 'CarController@searchByColumn')->name('admin/cars/search/byColumn');
        Route::get('cars/archives/{offset?}/{limit?}', 'CarController@archives')->name('admin/cars/archives');
        Route::get('cars/back', 'CarController@back')->name('admin/cars/back');
        Route::post('cars/pagination/archives/{offset?}/{limit?}', 'CarController@archivesPagination')->name('admin/cars/pagination/archives');
        Route::post('cars/search/archives', 'CarController@archivesSearch')->name('admin/cars/search/archives');
        Route::post('cars/search/byColumn/archives', 'CarController@archivesSearchByColumn')->name('admin/cars/search/byColumn/archives');
        Route::get('cars/orders/{offset?}/{limit?}', 'CarController@orders')->name('admin/cars/orders');
        
          
        // destination routes
        Route::get('destinations/index/{offset?}/{limit?}', 'DestinationController@index')->name('admin/destinations/index');
        Route::get('destinations/create', 'DestinationController@create')->name('admin/destinations/create');
        Route::post('destinations/create', 'DestinationController@store')->name('admin/destinations/store');
        Route::get('destinations/edit/{id?}', 'DestinationController@edit')->name('admin/destinations/edit');
        Route::post('destinations/edit/{id}', 'DestinationController@update')->name('admin/destinations/update');
        Route::get('destinations/activate', 'DestinationController@activate')->name('admin/destinations/activate');
        Route::get('destinations/delete', 'DestinationController@delete')->name('admin/destinations/delete');
        Route::post('destinations/pagination/{offset?}/{limit?}', 'DestinationController@pagination')->name('admin/destinations/pagination');
        Route::post('destinations/search', 'DestinationController@search')->name('admin/destinations/search');
        Route::post('destinations/search/byColumn', 'DestinationController@searchByColumn')->name('admin/destinations/search/byColumn');
        Route::get('destinations/archives/{offset?}/{limit?}', 'DestinationController@archives')->name('admin/destinations/archives');
        Route::get('destinations/back', 'DestinationController@back')->name('admin/destinations/back');
        Route::post('destinations/pagination/archives/{offset?}/{limit?}', 'DestinationController@archivesPagination')->name('admin/destinations/pagination/archives');
        Route::post('destinations/search/archives', 'DestinationController@archivesSearch')->name('admin/destinations/search/archives');
        Route::post('destinations/search/byColumn/archives', 'DestinationController@archivesSearchByColumn')->name('admin/destinations/search/byColumn/archives');
        Route::post('destinations/upload/albums/{id?}', 'DestinationController@uploadAlbums')->name('admin/destinations/upload/albums');
        Route::post('destinations/delete/img/{id?}', 'DestinationController@deleteImg')->name('admin/destinations/delete/img');
        
          
        // category routes
        Route::get('categories/index/{offset?}/{limit?}', 'CategoryController@index')->name('admin/categories/index');
        Route::get('categories/create', 'CategoryController@create')->name('admin/categories/create');
        Route::post('categories/create', 'CategoryController@store')->name('admin/categories/store');
        Route::get('categories/edit/{id?}', 'CategoryController@edit')->name('admin/categories/edit');
        Route::post('categories/edit/{id}', 'CategoryController@update')->name('admin/categories/update');
        Route::get('categories/activate', 'CategoryController@activate')->name('admin/categories/activate');
        Route::get('categories/delete', 'CategoryController@delete')->name('admin/categories/delete');
        Route::post('categories/pagination/{offset?}/{limit?}', 'CategoryController@pagination')->name('admin/categories/pagination');
        Route::post('categories/search', 'CategoryController@search')->name('admin/categories/search');
        Route::post('categories/search/byColumn', 'CategoryController@searchByColumn')->name('admin/categories/search/byColumn');
        Route::get('categories/archives/{offset?}/{limit?}', 'CategoryController@archives')->name('admin/categories/archives');
        Route::get('categories/back', 'CategoryController@back')->name('admin/categories/back');
        Route::post('categories/pagination/archives/{offset?}/{limit?}', 'CategoryController@archivesPagination')->name('admin/categories/pagination/archives');
        Route::post('categories/search/archives', 'CategoryController@archivesSearch')->name('admin/categories/search/archives');
        Route::post('categories/search/byColumn/archives', 'CategoryController@archivesSearchByColumn')->name('admin/categories/search/byColumn/archives');

        
          
        // country routes
        Route::get('countries/index/{offset?}/{limit?}', 'CountryController@index')->name('admin/countries/index');
        Route::get('countries/create', 'CountryController@create')->name('admin/countries/create');
        Route::post('countries/create', 'CountryController@store')->name('admin/countries/store');
        Route::get('countries/edit/{id?}', 'CountryController@edit')->name('admin/countries/edit');
        Route::post('countries/edit/{id}', 'CountryController@update')->name('admin/countries/update');
        Route::get('countries/activate', 'CountryController@activate')->name('admin/countries/activate');
        Route::get('countries/delete', 'CountryController@delete')->name('admin/countries/delete');
        Route::post('countries/pagination/{offset?}/{limit?}', 'CountryController@pagination')->name('admin/countries/pagination');
        Route::post('countries/search', 'CountryController@search')->name('admin/countries/search');
        Route::post('countries/search/byColumn', 'CountryController@searchByColumn')->name('admin/countries/search/byColumn');
        Route::get('countries/archives/{offset?}/{limit?}', 'CountryController@archives')->name('admin/countries/archives');
        Route::get('countries/back', 'CountryController@back')->name('admin/countries/back');
        Route::post('countries/pagination/archives/{offset?}/{limit?}', 'CountryController@archivesPagination')->name('admin/countries/pagination/archives');
        Route::post('countries/search/archives', 'CountryController@archivesSearch')->name('admin/countries/search/archives');
        Route::post('countries/search/byColumn/archives', 'CountryController@archivesSearchByColumn')->name('admin/countries/search/byColumn/archives');

        
          
        // captain routes
        Route::get('captains/index/{offset?}/{limit?}', 'CaptainController@index')->name('admin/captains/index');
        Route::get('captains/create', 'CaptainController@create')->name('admin/captains/create');
        Route::post('captains/create', 'CaptainController@store')->name('admin/captains/store');
        Route::get('captains/edit/{id?}', 'CaptainController@edit')->name('admin/captains/edit');
        Route::post('captains/edit/{id}', 'CaptainController@update')->name('admin/captains/update');
        Route::get('captains/activate', 'CaptainController@activate')->name('admin/captains/activate');
        Route::get('captains/delete', 'CaptainController@delete')->name('admin/captains/delete');
        Route::post('captains/pagination/{offset?}/{limit?}', 'CaptainController@pagination')->name('admin/captains/pagination');
        Route::post('captains/search', 'CaptainController@search')->name('admin/captains/search');
        Route::post('captains/search/byColumn', 'CaptainController@searchByColumn')->name('admin/captains/search/byColumn');
        Route::get('captains/archives/{offset?}/{limit?}', 'CaptainController@archives')->name('admin/captains/archives');
        Route::get('captains/back', 'CaptainController@back')->name('admin/captains/back');
        Route::post('captains/pagination/archives/{offset?}/{limit?}', 'CaptainController@archivesPagination')->name('admin/captains/pagination/archives');
        Route::post('captains/search/archives', 'CaptainController@archivesSearch')->name('admin/captains/search/archives');
        Route::post('captains/search/byColumn/archives', 'CaptainController@archivesSearchByColumn')->name('admin/captains/search/byColumn/archives');

        
          
        // info routes
        Route::get('info/index/{offset?}/{limit?}', 'InfoController@index')->name('admin/info/index');
        Route::get('info/create', 'InfoController@create')->name('admin/info/create');
        Route::post('info/create', 'InfoController@store')->name('admin/info/store');
        Route::get('info/edit/{id?}', 'InfoController@edit')->name('admin/info/edit');
        Route::post('info/edit/{id}', 'InfoController@update')->name('admin/info/update');
        Route::get('info/activate', 'InfoController@activate')->name('admin/info/activate');
        Route::get('info/delete', 'InfoController@delete')->name('admin/info/delete');
        Route::post('info/pagination/{offset?}/{limit?}', 'InfoController@pagination')->name('admin/info/pagination');
        Route::post('info/search', 'InfoController@search')->name('admin/info/search');
        Route::post('info/search/byColumn', 'InfoController@searchByColumn')->name('admin/info/search/byColumn');
        Route::get('info/archives/{offset?}/{limit?}', 'InfoController@archives')->name('admin/info/archives');
        Route::get('info/back', 'InfoController@back')->name('admin/info/back');
        Route::post('info/pagination/archives/{offset?}/{limit?}', 'InfoController@archivesPagination')->name('admin/info/pagination/archives');
        Route::post('info/search/archives', 'InfoController@archivesSearch')->name('admin/info/search/archives');
        Route::post('info/search/byColumn/archives', 'InfoController@archivesSearchByColumn')->name('admin/info/search/byColumn/archives');
        

        // wallets routes
        Route::get('wallets/index/{offset?}/{limit?}', 'WalletController@index')->name('admin/wallets/index');
        Route::get('wallets/confirm-withdraw/{id?}', 'WalletController@confirm_withdraw')->name('admin/wallets/confirm-withdraw');
        
          
        // rating routes
        Route::get('ratings/index/{offset?}/{limit?}', 'RatingController@index')->name('admin/ratings/index');
        Route::get('ratings/create', 'RatingController@create')->name('admin/ratings/create');
        Route::post('ratings/create', 'RatingController@store')->name('admin/ratings/store');
        Route::get('ratings/edit/{id?}', 'RatingController@edit')->name('admin/ratings/edit');
        Route::post('ratings/edit/{id}', 'RatingController@update')->name('admin/ratings/update');
        Route::get('ratings/activate', 'RatingController@activate')->name('admin/ratings/activate');
        Route::get('ratings/delete', 'RatingController@delete')->name('admin/ratings/delete');
        Route::post('ratings/pagination/{offset?}/{limit?}', 'RatingController@pagination')->name('admin/ratings/pagination');
        Route::post('ratings/search', 'RatingController@search')->name('admin/ratings/search');
        Route::post('ratings/search/byColumn', 'RatingController@searchByColumn')->name('admin/ratings/search/byColumn');
        Route::get('ratings/archives/{offset?}/{limit?}', 'RatingController@archives')->name('admin/ratings/archives');
        Route::get('ratings/back', 'RatingController@back')->name('admin/ratings/back');
        Route::post('ratings/pagination/archives/{offset?}/{limit?}', 'RatingController@archivesPagination')->name('admin/ratings/pagination/archives');
        Route::post('ratings/search/archives', 'RatingController@archivesSearch')->name('admin/ratings/search/archives');
        Route::post('ratings/search/byColumn/archives', 'RatingController@archivesSearchByColumn')->name('admin/ratings/search/byColumn/archives');

        
          
        // roomType routes
        Route::get('roomTypes/index/{offset?}/{limit?}', 'RoomTypeController@index')->name('admin/roomTypes/index');
        Route::get('roomTypes/create', 'RoomTypeController@create')->name('admin/roomTypes/create');
        Route::post('roomTypes/create', 'RoomTypeController@store')->name('admin/roomTypes/store');
        Route::get('roomTypes/edit/{id?}', 'RoomTypeController@edit')->name('admin/roomTypes/edit');
        Route::post('roomTypes/edit/{id}', 'RoomTypeController@update')->name('admin/roomTypes/update');
        Route::get('roomTypes/activate', 'RoomTypeController@activate')->name('admin/roomTypes/activate');
        Route::get('roomTypes/delete', 'RoomTypeController@delete')->name('admin/roomTypes/delete');
        Route::post('roomTypes/pagination/{offset?}/{limit?}', 'RoomTypeController@pagination')->name('admin/roomTypes/pagination');
        Route::post('roomTypes/search', 'RoomTypeController@search')->name('admin/roomTypes/search');
        Route::post('roomTypes/search/byColumn', 'RoomTypeController@searchByColumn')->name('admin/roomTypes/search/byColumn');
        Route::get('roomTypes/archives/{offset?}/{limit?}', 'RoomTypeController@archives')->name('admin/roomTypes/archives');
        Route::get('roomTypes/back', 'RoomTypeController@back')->name('admin/roomTypes/back');
        Route::post('roomTypes/pagination/archives/{offset?}/{limit?}', 'RoomTypeController@archivesPagination')->name('admin/roomTypes/pagination/archives');
        Route::post('roomTypes/search/archives', 'RoomTypeController@archivesSearch')->name('admin/roomTypes/search/archives');
        Route::post('roomTypes/search/byColumn/archives', 'RoomTypeController@archivesSearchByColumn')->name('admin/roomTypes/search/byColumn/archives');

        
          
        // option routes
        Route::get('options/index/{offset?}/{limit?}', 'OptionController@index')->name('admin/options/index');
        Route::get('options/create', 'OptionController@create')->name('admin/options/create');
        Route::post('options/create', 'OptionController@store')->name('admin/options/store');
        Route::get('options/edit/{id?}', 'OptionController@edit')->name('admin/options/edit');
        Route::post('options/edit/{id}', 'OptionController@update')->name('admin/options/update');
        Route::get('options/activate', 'OptionController@activate')->name('admin/options/activate');
        Route::get('options/delete', 'OptionController@delete')->name('admin/options/delete');
        Route::post('options/pagination/{offset?}/{limit?}', 'OptionController@pagination')->name('admin/options/pagination');
        Route::post('options/search', 'OptionController@search')->name('admin/options/search');
        Route::post('options/search/byColumn', 'OptionController@searchByColumn')->name('admin/options/search/byColumn');
        Route::get('options/archives/{offset?}/{limit?}', 'OptionController@archives')->name('admin/options/archives');
        Route::get('options/back', 'OptionController@back')->name('admin/options/back');
        Route::post('options/pagination/archives/{offset?}/{limit?}', 'OptionController@archivesPagination')->name('admin/options/pagination/archives');
        Route::post('options/search/archives', 'OptionController@archivesSearch')->name('admin/options/search/archives');
        Route::post('options/search/byColumn/archives', 'OptionController@archivesSearchByColumn')->name('admin/options/search/byColumn/archives');

        
          
        // room routes
        Route::get('rooms/index/{offset?}/{limit?}', 'RoomController@index')->name('admin/rooms/index');
        Route::get('rooms/create', 'RoomController@create')->name('admin/rooms/create');
        Route::post('rooms/create', 'RoomController@store')->name('admin/rooms/store');
        Route::get('rooms/edit/{id?}', 'RoomController@edit')->name('admin/rooms/edit');
        Route::post('rooms/edit/{id}', 'RoomController@update')->name('admin/rooms/update');
        Route::get('rooms/activate', 'RoomController@activate')->name('admin/rooms/activate');
        Route::get('rooms/delete', 'RoomController@delete')->name('admin/rooms/delete');
        Route::post('rooms/pagination/{offset?}/{limit?}', 'RoomController@pagination')->name('admin/rooms/pagination');
        Route::post('rooms/search', 'RoomController@search')->name('admin/rooms/search');
        Route::post('rooms/search/byColumn', 'RoomController@searchByColumn')->name('admin/rooms/search/byColumn');
        Route::get('rooms/archives/{offset?}/{limit?}', 'RoomController@archives')->name('admin/rooms/archives');
        Route::get('rooms/back', 'RoomController@back')->name('admin/rooms/back');
        Route::post('rooms/pagination/archives/{offset?}/{limit?}', 'RoomController@archivesPagination')->name('admin/rooms/pagination/archives');
        Route::post('rooms/search/archives', 'RoomController@archivesSearch')->name('admin/rooms/search/archives');
        Route::post('rooms/search/byColumn/archives', 'RoomController@archivesSearchByColumn')->name('admin/rooms/search/byColumn/archives');

            
        // contact routes
        Route::get('contacts/index/{offset?}/{limit?}', 'ContactController@index')->name('admin/contacts/index');
        Route::get('contacts/create', 'ContactController@create')->name('admin/contacts/create');
        Route::post('contacts/create', 'ContactController@store')->name('admin/contacts/store');
        Route::get('contacts/edit/{id?}', 'ContactController@edit')->name('admin/contacts/edit');
        Route::post('contacts/edit/{id}', 'ContactController@update')->name('admin/contacts/update');
        Route::get('contacts/activate', 'ContactController@activate')->name('admin/contacts/activate');
        Route::get('contacts/delete', 'ContactController@delete')->name('admin/contacts/delete');
        Route::post('contacts/pagination/{offset?}/{limit?}', 'ContactController@pagination')->name('admin/contacts/pagination');
        Route::post('contacts/search', 'ContactController@search')->name('admin/contacts/search');
        Route::post('contacts/search/byColumn', 'ContactController@searchByColumn')->name('admin/contacts/search/byColumn');
        Route::get('contacts/archives/{offset?}/{limit?}', 'ContactController@archives')->name('admin/contacts/archives');
        Route::get('contacts/back', 'ContactController@back')->name('admin/contacts/back');
        Route::post('contacts/pagination/archives/{offset?}/{limit?}', 'ContactController@archivesPagination')->name('admin/contacts/pagination/archives');
        Route::post('contacts/search/archives', 'ContactController@archivesSearch')->name('admin/contacts/search/archives');
        Route::post('contacts/search/byColumn/archives', 'ContactController@archivesSearchByColumn')->name('admin/contacts/search/byColumn/archives');

            
        
      //ROUTEFROMCOMMANDLINE

    });
});
